
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <math.h>
#include <stdio.h>
#include <limits>
#include <bitset>

using namespace std;

map<int, vector<int>> globalHowToGetToCity;
int globalN;

vector<int> makeCycle (bitset<100000> visitedCities, int visitedCitiesSize, int startCity, vector<int> road) {
    road[visitedCitiesSize] = startCity;
    visitedCities[startCity] = 1;
    visitedCitiesSize++;

    if (visitedCitiesSize == globalN) {
        vector<int> gHTGTCSC = globalHowToGetToCity[startCity];
        if (find(gHTGTCSC.begin(), gHTGTCSC.end(), 1) != gHTGTCSC.end()) {
            road[globalN] = 1;
            return road;
        }
        return { -1 };
    }

    for (int city : globalHowToGetToCity[startCity]) {
        if (!visitedCities[city]) {
            vector<int> cycle = makeCycle(visitedCities, visitedCitiesSize, city, road);
            if (cycle[0] != -1) {
                return cycle;
            }
        }
    }
    return { -1 };
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    
    int n, m;
    cin >> n >> m;

    globalN = n;

    map<int, vector<int>> howToGetToCity;


    int j = 0;

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        howToGetToCity[b].push_back(a);
    }

    globalHowToGetToCity = howToGetToCity;
    bitset<100000> visitedCities;

    vector<int> result = {-1};

    vector<int> road(n + 1);

    result = makeCycle(visitedCities, 0, 1, road);
    
    if (result[0] == -1) {
        printf("NO");
        return 0;
    }
    printf("YES\n");
    for (int i = n; i >= 0; i--) {
        printf("%i ", result[i]);
    }

}